<?php

use App\Http\Controllers\Admin\AdminController;
use Illuminate\Support\Facades\Route;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider and all of them will
| be assigned to the "web" middleware group. Make something great!
|
*/

Route::get('/', function () {
    return view('welcome');
});

Route::prefix('admin')->group(function () {

    Route::get('/dashboard', [AdminController::class, 'dashboard'])->name('admin.dashboard');
    Route::get('/user', [AdminController::class, 'user'])->name('admin.user');
    Route::get('/guardian', [AdminController::class, 'guardian'])->name('admin.guardian');
    Route::get('/package', [AdminController::class, 'package'])->name('admin.package');
    Route::get('/post', [AdminController::class, 'post'])->name('admin.post');
    Route::get('/personality-test', [AdminController::class, 'personality_test'])->name('admin.personality_test');
    Route::get('/contact', [AdminController::class, 'contact'])->name('admin.contact');
    Route::get('/login', [AdminController::class, 'login'])->name('admin.login');
    Route::get('/user-detail/{id}', [AdminController::class, 'user_detail'])->name('admin.user_detail');
    // Route::post('/authenticate', [AdminController::class, 'authenticate'])->name('admin.authenticate');

    Route::group(['middleware' => 'auth:web'], function () {
        // Route::get('/dashboard', [AdminController::class, 'dashboard'])->name('admin.dashboard');
        // Route::get('/all-users', [AdminController::class, 'allUsers'])->name('admin.allUsers');
        // Route::get('/all-salons', [AdminController::class, 'allSalons'])->name('admin.allSalons');
        // Route::get('/logout', [AdminController::class, 'logout'])->name('admin.logout');
        // Route::get('/all-staff', [AdminController::class, 'allStaff'])->name('admin.allStaff');
    });
});