<?php

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\Api\UserController;
use App\Http\Controllers\Api\GuardianController;
use App\Http\Controllers\Api\PaymentGatewayController;

/*
|--------------------------------------------------------------------------
| API Routes
|--------------------------------------------------------------------------
|
| Here is where you can register API routes for your application. These
| routes are loaded by the RouteServiceProvider and all of them will
| be assigned to the "api" middleware group. Make something great!
|
*/

// Route::middleware('auth:sanctum')->get('/user', function (Request $request) {
//     return $request->user();
// });

Route::prefix('admin')->group(function () {
    Route::post('/auth', [UserController::class, 'admin_authenticate'])->name('admin.auth');
    Route::post('/dashboard', [UserController::class, 'dashboard'])->name('admin.dashboard');
    Route::get('/employees', [UserController::class, 'get_all_employees'])->name('admin.getAllEmployees');
});

Route::prefix('user')->group(function () {
    Route::post('/register', [UserController::class, 'register'])->name('user.register');
    Route::post('/login', [UserController::class, 'authenticate'])->name('user.login');
    Route::post('/social-login', [UserController::class, 'social_register'])->name('user.socialLogin');
    Route::post('/forgot-password', [UserController::class, 'forgot_password'])->name('user.forgotPassword');
    Route::post('/verification', [UserController::class, 'verification'])->name('user.verification');
    Route::post('/update-password', [UserController::class, 'update_password'])->name('user.updatePassword');
    Route::post('/profile', [UserController::class, 'profile'])->name('user.profilePost')->middleware('auth:api');
    Route::post('/profile-guardian', [UserController::class, 'profile_guardian'])->name('user.profileGuardian')->middleware('auth:api');
    Route::post('/profile-about', [UserController::class, 'profile_about'])->name('user.profileAbout')->middleware('auth:api');
    Route::post('/profile-height', [UserController::class, 'profile_height'])->name('user.profileHeight')->middleware('auth:api');
    Route::post('/profile-appearance', [UserController::class, 'profile_appearance'])->name('user.profileAppearance')->middleware('auth:api');
    Route::post('/profile-opento', [UserController::class, 'profile_opento'])->name('user.profileOpento')->middleware('auth:api');
    Route::post('/profile-islam', [UserController::class, 'profile_islam'])->name('user.profileIslam')->middleware('auth:api');
    Route::post('/profile-self', [UserController::class, 'profile_self'])->name('user.profileSelf')->middleware('auth:api');
    Route::post('/profile-religion', [UserController::class, 'profile_religion'])->name('user.profileReligion')->middleware('auth:api');
    Route::post('/profile-interest', [UserController::class, 'profile_interest'])->name('user.profileInterest')->middleware('auth:api');
    Route::get('/dashboard', [UserController::class, 'dashboard'])->name('user.dashboard')->middleware('auth:api');
    Route::get('/profile/{id}', [UserController::class, 'profile_detail'])->name('user.profileDetail')->middleware('auth:api');
    Route::post('/request-send', [UserController::class, 'send_request'])->name('user.requestSend')->middleware('auth:api');
    Route::post('/request-accept', [UserController::class, 'accept_request'])->name('user.requestAccept')->middleware('auth:api');
    Route::post('/request-decline', [UserController::class, 'decline_request'])->name('user.requestDecline')->middleware('auth:api');
    Route::get('/request-all', [UserController::class, 'get_all_request'])->name('user.requestAll')->middleware('auth:api');
    Route::get('/personality-question', [UserController::class, 'get_all_question'])->name('user.questionAll')->middleware('auth:api');
    Route::post('/personality-test', [UserController::class, 'personality_test'])->name('user.personalityTest')->middleware('auth:api');
    Route::get('/packages', [UserController::class, 'get_all_packages'])->name('user.packages')->middleware('auth:api');
    Route::post('/post-create', [UserController::class, 'create_post'])->name('user.postCreate')->middleware('auth:api');
    Route::post('/post-edit', [UserController::class, 'edit_post'])->name('user.postEdit')->middleware('auth:api');
    Route::post('/post-delete', [UserController::class, 'delete_post'])->name('user.postDelete')->middleware('auth:api');
    Route::get('/post-all', [UserController::class, 'get_all_post'])->name('user.postAll')->middleware('auth:api');
    Route::post('/post-like', [UserController::class, 'like_post'])->name('user.postLike')->middleware('auth:api');
    Route::post('/post-unlike', [UserController::class, 'unlike_post'])->name('user.postUnlike')->middleware('auth:api');
    Route::post('/post-comment', [UserController::class, 'comment_add'])->name('user.postAddComment')->middleware('auth:api');
    Route::get('/comment-all', [UserController::class, 'get_all_comment'])->name('user.getAllComment')->middleware('auth:api');
    Route::post('/contact', [UserController::class, 'contact'])->name('user.contact')->middleware('auth:api');
    Route::get('/notification', [UserController::class, 'get_all_notification'])->name('user.notification')->middleware('auth:api');
    Route::post('/subscription', [UserController::class, 'subscription'])->name('user.subscription')->middleware('auth:api');
    Route::get('/settings', [UserController::class, 'get_all_settings'])->name('user.get_all_settings')->middleware('auth:api');
    Route::post('/boost-profile', [UserController::class, 'boost'])->name('user.boost')->middleware('auth:api');
});
