<?php

namespace App\Http\Middleware;

use Illuminate\Auth\Middleware\Authenticate as Middleware;
use Illuminate\Http\Request;

class Authenticate extends Middleware
{
    /**
     * Get the path the user should be redirected to when they are not authenticated.
     */
    protected function redirectTo(Request $request): ?string
    {
        $segment = $request->segment(1);
        if ($segment == 'api') {
            abort(response()->json(
                [
                    'status' => false,
                    'message' => 'Login To Your account!',
                ],
                401
            ));
        }

        if (!$request->expectsJson()) {
            return route('user.login');
        }
        //return $request->expectsJson() ? null : route('login');
    }
}
